/*

  JAVASCRIPT CONSOLE OBJECT v1.01 FOR SPHERE
  by Sulphur21

  === SUMMARY =========================================================
  
  The object type JSConsole() enables you to include a JavaScript
  console into your game.

  
  === LICENSE =========================================================

  Copyright (c) 2006 Sulphur21

  Permission is hereby granted, free of charge, to any person obtaining
  a copy of this software and associated documentation files (the
  "Software"), to deal in the Software without restriction, including
  without limitation the rights to use, copy, modify, merge, publish,
  distribute, sublicense, and/or sell copies of the Software, and to
  permit persons to whom the Software is furnished to do so, subject to
  the following conditions:

  The above copyright notice and this permission notice shall be
  included in all copies or substantial portions of the Software.

  THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
  EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
  MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
  NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS
  BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN
  ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
  CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
  SOFTWARE.

  
  === USAGE ===========================================================

  For a detailed documentation of this script, go to 
    http://www.spheredev.org/wiki/jsconsole.js
  I'd be pleased to receive comments or bugreports by people who found
  it helpful. You can find me at
    http://www.spheredev.org/forums
  
  Have fun everyone!
  Sulphur21
  
*/

///////////////////////////////////////////////////////////////////////

/*
  Constructor of the JSConsole object type.
*/
function JSConsole() {
  // Look & feel
  this.keyboardLayout = undefined;
  this.font1 = GetSystemFont();
  this.font2 = this.font1.clone();
    this.font2.setColorMask(CreateColor(255,255,0));
  this.cursor = "|";
  this.inSym = "I>";
  this.outSym = "O>";
  this.title = "[Javascript Console]";
  // Controller vars
  this.currText = "";
  this.prevText = "";
  this.bufText = new Array();
  this.cursorX = 0;
  this.pagePos = 0;
  // Often used constants
  this.scrH = GetScreenHeight();
  this.scrW = GetScreenWidth();
  this.fntHt = this.font1.getHeight();
  this.scrL = Math.floor(this.scrH/this.fntHt);
}

///////////////////////////////////////////////////////////////////////

/*
  This method runs the console.
  It's the only usuable public method of the JSConsole() object type.
  Don't call its other methods.
*/
JSConsole.prototype.run = function()
{
  var Key, Shift, AltGr, Time, ReposPage, Temp1, Temp2, Temp3, Temp4;
  var LastBlink = GetTime(), currWrap1 = [""], currWrap2 = [""];

  // Run until ESCAPE is pressed
  while (Key != KEY_ESCAPE) {

    // Need time for cursor blinking
    Time = GetTime();

    // Handle key input
    if (AreKeysLeft()) {
      Key = GetKey();
      Shift = IsKeyPressed(KEY_SHIFT);
      AltGr = IsKeyPressed(KEY_ALT) && IsKeyPressed(KEY_CTRL);
      
      switch (Key)
      {
        case KEY_LEFT:
          if (this.cursorX > 0)
            this.cursorX--;
          else
            if (this.currText.length == 0)
              this.currText = this.prevText;
          ReposPage = true;
        break;

        case KEY_RIGHT:
          if (this.cursorX < this.currText.length)
            this.cursorX++;
          ReposPage = true;
        break;

        case KEY_HOME:
          if (Shift)
            this.pagePos = 0;
          else {
            this.cursorX = 0;
            ReposPage = true;
          }
        break;

        case KEY_END:
          if (Shift)
            this.pagePos = Math.max(0, this.bufText.length+currWrap1.length-this.scrL+1);
          else {
            this.cursorX = this.currText.length;
            ReposPage = true;
          }
        break;
      
        case KEY_UP:
          if (this.pagePos > 0)
            this.pagePos--;
        break;
        
        case KEY_DOWN:
          if (this.pagePos < this.bufText.length+currWrap1.length-this.scrL+1)
            this.pagePos++;
        break;
        
        case KEY_PAGEUP:
          this.pagePos -= this.scrL-1;
          if (this.pagePos < 0)
            this.pagePos = 0;
        break;
        
        case KEY_PAGEDOWN:
          this.pagePos += this.scrL-1;
          if (this.pagePos > this.bufText.length+currWrap1.length-this.scrL+1)
            this.pagePos = Math.max(0, this.bufText.length+currWrap1.length-this.scrL+1);
        break;
        
        case KEY_ENTER:
          Temp1 = this.stringWrap(this.inSym+this.currText);
          while (Temp1.length)
            this.bufText.push(Temp1.shift());
          Temp2 = this.stringWrap(this.outSym+this.evalCode(this.currText));
          while (Temp2.length)
            this.bufText.push(Temp2.shift());
          this.prevText = this.currText;
          this.currText = "";
          this.cursorX = 0;
          ReposPage = true;
        break;
        
        case KEY_F8:
          this.prevText = this.currText;
          this.currText = "";
          this.bufText = new Array();
          this.cursorX = 0;
          this.pagePos = 0;
        break;        
        
        case KEY_BACKSPACE:
          if (this.cursorX > 0) {
            this.currText = this.currText.substring(0, this.cursorX-1) +
              this.currText.substring(this.cursorX);
            this.cursorX--;
          }
          ReposPage = true;
        break;
        
        case KEY_DELETE:
          if (this.cursorX < this.currText.length)
            this.currText = this.currText.substring(0, this.cursorX) +
              this.currText.substring(this.cursorX+1);
          ReposPage = true;
        break;
        
        default:
          if (this.keyboardLayout) {
            Temp1 = GetKeyStr(Key, Shift, AltGr, this.keyboardLayout);
          } else {
							if(!IsKeyPressed(KEY_1)){Temp1 = GetKeyString(Key, Shift);
						}else{if(Shift) Temp1 = "=";if(!Shift) Temp1="1"}
          }
          if (Temp1.length > 0) {
            this.currText = this.currText.substring(0, this.cursorX) + Temp1
              + this.currText.substring(this.cursorX);
            this.cursorX += Temp1.length;
            ReposPage = true;
          }
        break;
      } // END switch
      
      // Make cursor visible if any key pressed
      LastBlink = Time;
    } // END if
    
    // Wrap current command line
    currWrap1 = this.stringWrap(this.inSym+this.currText);
    
    // Get cursor position
    for (Temp1=0, Temp2=-this.inSym.length; Temp1<currWrap1.length; Temp1++) {
      Temp3  = Temp2;
      Temp2 += currWrap1[Temp1].length;
      if (Temp2 > this.cursorX) {
        currWrap2 = new Array(Temp1);
        currWrap2.push(currWrap1[Temp1].substring(0, this.cursorX-Temp3)
          +this.cursor);
        break;
      }
    }
    
    // Reposition page to ensure cursor visibility
    if (ReposPage) {
      Temp3 = this.bufText.length+currWrap2.length-1;
      if (this.pagePos > Temp3)
        this.pagePos = Temp3;
      if (this.pagePos < Temp3-this.scrL+2)
        this.pagePos = Temp3-this.scrL+2;
      ReposPage = false;
    }
    
    // Draw text buffer of session
    for (
      Temp3=this.pagePos, Temp4=1;
      Temp3<this.bufText.length && Temp4<this.scrL;
      Temp3++, Temp4++
    )
      this.font1.drawText(0, Temp4*this.fntHt, this.bufText[Temp3]);
    
    // Draw current command line including cursor
    for (
      Temp3=Math.max(0, this.pagePos-this.bufText.length);
      Temp3<currWrap1.length && Temp4<this.scrL;
      Temp3++, Temp4++
    ) {
      this.font1.drawText(0, Temp4*this.fntHt, currWrap1[Temp3]);
      if (Time < LastBlink+400 && Temp3 == currWrap2.length-1)
        this.font1.drawText(0, Temp4*this.fntHt, currWrap2[Temp3]);
    }
    
    // Manage cursor blinking timer
    if (Time >= LastBlink+800 || Time < LastBlink)
      LastBlink=Time;
    
    // Draw title and flip screen
    this.font2.drawText(0, 0, this.title);
    FlipScreen();
    
  } // END while
}

///////////////////////////////////////////////////////////////////////

/*
  Evaluates a piece of code and returns result.
  Has been placed outside of the run() method for not to interfere with
  its local variables.
*/
JSConsole.prototype.evalCode = function(EvalCodeParameter) {
  var EvalCodeResult, EvalCodeException;
  try {
    EvalCodeResult = eval(EvalCodeParameter);
  } catch (EvalCodeException) {
    EvalCodeResult = EvalCodeException;
  }
  return EvalCodeResult;
}

///////////////////////////////////////////////////////////////////////

/*
  Simple text-wrapping function, Specialized for internal use!
*/
JSConsole.prototype.stringWrap = function(str) {
  var result = [""];
  // split string into different words
  var words = str.split(" ");
  // loop through words
  while(words.length) {
    // place word on current line if possible...
    if (this.font1.getStringWidth(result[result.length-1]+words[0]) <= this.scrW)
      result[result.length-1] += words.shift()+" ";
    else {
      // ... otherwise place word on next line, unless it's too long...
      if (this.font1.getStringWidth(words[0]) <= this.scrW)
        result.push(words.shift()+" ");
      else {
        // ... if too long break word into seperate lines.
        if (result[result.length-1] != "")
          result.push("");
        for (var i=0, j; i<words[0].length; i++) {
          j = words[0].charAt(i);
          if (this.font1.getStringWidth(result[result.length-1]+j) <= this.scrW)
            result[result.length-1] += j;
          else
            result.push(j);
        }
        result[result.length-1] += " ";
        words.shift();
      }
    }
  }
  return result;
}

///////////////////////////////////////////////////////////////////////

/* EOF */

